<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Insert sample exams
    $exams = [
        [
            'title' => 'PHP Fundamentals Quiz',
            'slug' => 'php-fundamentals-quiz',
            'description' => 'Test your knowledge of PHP basics including variables, functions, and control structures.',
            'course_id' => null,
            'instructor_id' => 1,
            'exam_type' => 'quiz',
            'total_points' => 20,
            'passing_score' => 70,
            'time_limit' => 30, // 30 minutes
            'max_attempts' => 3,
            'price' => 0.00,
            'currency' => 'USD',
            'is_free' => true,
            'status' => 'published'
        ],
        [
            'title' => 'Advanced JavaScript Certification',
            'slug' => 'advanced-javascript-certification',
            'description' => 'Comprehensive exam covering advanced JavaScript concepts including closures, prototypes, and async programming.',
            'course_id' => null,
            'instructor_id' => 1,
            'exam_type' => 'certification',
            'total_points' => 50,
            'passing_score' => 80,
            'time_limit' => 60, // 60 minutes
            'max_attempts' => 1,
            'price' => 25.00,
            'currency' => 'USD',
            'is_free' => false,
            'status' => 'published'
        ],
        [
            'title' => 'Database Design Midterm',
            'slug' => 'database-design-midterm',
            'description' => 'Midterm examination covering database design principles, normalization, and SQL queries.',
            'course_id' => null,
            'instructor_id' => 1,
            'exam_type' => 'midterm',
            'total_points' => 40,
            'passing_score' => 65,
            'time_limit' => 45,
            'max_attempts' => 2,
            'price' => 15.00,
            'currency' => 'USD',
            'is_free' => false,
            'status' => 'published'
        ],
        [
            'title' => 'Web Development Practice Test',
            'slug' => 'web-development-practice-test',
            'description' => 'Practice exam for web development covering HTML, CSS, JavaScript, and responsive design.',
            'course_id' => null,
            'instructor_id' => 1,
            'exam_type' => 'practice',
            'total_points' => 30,
            'passing_score' => 60,
            'time_limit' => 25,
            'max_attempts' => 5,
            'price' => 0.00,
            'currency' => 'USD',
            'is_free' => true,
            'status' => 'published'
        ]
    ];

    foreach ($exams as $exam) {
        $stmt = $pdo->prepare("
            INSERT INTO exams (
                title, slug, description, course_id, instructor_id, exam_type,
                total_points, passing_score, time_limit, max_attempts,
                price, currency, is_free, status, created_at, updated_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
        ");

        $stmt->execute([
            $exam['title'],
            $exam['slug'],
            $exam['description'],
            $exam['course_id'],
            $exam['instructor_id'],
            $exam['exam_type'],
            $exam['total_points'],
            $exam['passing_score'],
            $exam['time_limit'],
            $exam['max_attempts'],
            $exam['price'],
            $exam['currency'],
            $exam['is_free'],
            $exam['status']
        ]);
    }

    echo "Sample exams added successfully.";

} catch (PDOException $e) {
    echo "Error adding sample exams: " . $e->getMessage();
}
?>